package com.example.roiencodedemo;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Bundle;
import android.util.Log;

import androidx.appcompat.app.AppCompatActivity;

import com.itgsa.opensdk.roiencode.RoiencodeClient;

import java.io.IOException;
import java.nio.ByteBuffer;

public class MainActivity extends AppCompatActivity {
    private static final String TAG = MainActivity.class.getSimpleName();
    private Context mContext;
    private MediaFormat mEncodeMediaFormat;
    private MediaCodec mEncode = null;
    public boolean isRuning = false;
    private int TIMEOUT_USEC = 12000;
    protected MediaCodec.BufferInfo mBufferInfo;
    private RoiencodeClient mRoiencodeClient;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        mContext = getApplicationContext();
        mBufferInfo = new MediaCodec.BufferInfo();
        createCodec();
        mRoiencodeClient  = RoiencodeClient.initialize(mContext);

        int version = mRoiencodeClient.getVersion();
        Log.d("ROI", "version is: " + version);
        //不支持的版本，三方可选择自行适配（部分接口如果后续进行了拓展需要）
        if (version < 10000) {
            //其他替代方案或界面提示
            Log.d("ROI", "version is false");
        } else {
            Log.d("ROI", "version is true");
        }
        
        boolean isRoiSupported = mRoiencodeClient.isRoiEncodeSupported(mEncode);
        if (isRoiSupported == true) {
            Log.d("ROI", "ROI is supported");
        } else {
            Log.d("ROI", "ROI is not supported");
        }
        int error = mRoiencodeClient.enableRoiEncode(mEncodeMediaFormat, 1);
        Log.d("onCreate","enableRoiEncode return : " + error);
        mEncode.configure(mEncodeMediaFormat, null, null, MediaCodec.CONFIGURE_FLAG_ENCODE);
        mEncode.start();
        StartEncoderThread();
    }

    protected void createCodec() {
        mEncodeMediaFormat = MediaFormat.createVideoFormat("video/avc", 1280, 720);
        mEncodeMediaFormat.setInteger(MediaFormat.KEY_COLOR_FORMAT, MediaCodecInfo.CodecCapabilities.COLOR_FormatYUV420SemiPlanar);
        mEncodeMediaFormat.setInteger(MediaFormat.KEY_FRAME_RATE, 30);
        mEncodeMediaFormat.setInteger(MediaFormat.KEY_I_FRAME_INTERVAL, 1);
        mEncodeMediaFormat.setInteger(MediaFormat.KEY_BIT_RATE, 2000000);
        mEncodeMediaFormat.setInteger(MediaFormat.KEY_BITRATE_MODE, MediaCodecInfo.EncoderCapabilities.BITRATE_MODE_VBR);
        //mEncodeMediaFormat.setInteger(MediaFormat.KEY_BITRATE_MODE, MediaCodecInfo.EncoderCapabilities.BITRATE_MODE_CBR);
        mEncodeMediaFormat.setInteger(MediaFormat.KEY_PROFILE, MediaCodecInfo.CodecProfileLevel.AVCProfileMain);
        mEncodeMediaFormat.setInteger("level", MediaCodecInfo.CodecProfileLevel.AVCLevel41);

        try {
            mEncode = MediaCodec.createEncoderByType("video/avc");
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void StartEncoderThread(){
        Thread Encoder1Thread = new Thread(new Runnable() {
            @SuppressLint("NewApi")
            @Override
            public void run() {
                isRuning = true;
                long pts =  0;
                long generateIndex = 0;
                long outIndex = 0;
                while (isRuning) {
                    byte[] input = new byte[1280*720*3/2];
                    //byte[] inputRoiMap = null;
                    if(outIndex >= 100) {
                        isRuning = false;
                    }
                    String codecName = mEncode.getName();

                    if (input != null) {
                        try {
                            long startMs = System.currentTimeMillis();
                            ByteBuffer[] inputBuffers = mEncode.getInputBuffers();
                            int inputBufferIndex = mEncode.dequeueInputBuffer(-1);
                            if (inputBufferIndex >= 0) {
                                pts = computePresentationTime(generateIndex);
                                Log.d("StartEncoderThread","setRoiParameter");
                                String ROI = "100,100-336,600=-6;118,230-336,448=-6";
                                mRoiencodeClient.setRoiParameter(mEncode, ROI, pts);

                                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                                inputBuffer.clear();
                                inputBuffer.put(input);
                                mEncode.queueInputBuffer(inputBufferIndex, 0, input.length, pts, 0);
                                generateIndex += 1;
                            }

                            Log.d("StartEncoderThread","generateIndex is : " + generateIndex);
                            ByteBuffer[] outputBuffers = mEncode.getOutputBuffers();
                            int encoderStatus = mEncode.dequeueOutputBuffer(mBufferInfo, TIMEOUT_USEC);

                            do {
                                if (encoderStatus == MediaCodec.INFO_TRY_AGAIN_LATER) {
                                    // no output available yet
                                } else if (encoderStatus == MediaCodec.INFO_OUTPUT_BUFFERS_CHANGED) {
                                    // not expected for an encoder
                                    outputBuffers = mEncode.getOutputBuffers();
                                } else if (encoderStatus == MediaCodec.INFO_OUTPUT_FORMAT_CHANGED) {
                                    // not expected for an encoder
                                } else if (encoderStatus < 0) {
                                    Log.d("StartEncoderThread","unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                                } else {
                                    ByteBuffer outputBuffer = outputBuffers[encoderStatus];

                                    if (outputBuffer == null) {
                                        throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                                    }

                                    if ((mBufferInfo.flags & MediaCodec.BUFFER_FLAG_CODEC_CONFIG) != 0) {
                                        // The codec config data was pulled out and fed to the muxer when we got
                                        // the INFO_OUTPUT_FORMAT_CHANGED status.  Ignore it.
                                        mBufferInfo.size = 0;
                                    }

                                    if (mBufferInfo.size != 0) {
                                        //adjust the ByteBuffer values to match BufferInfo (not needed?)
                                        outputBuffer.position(mBufferInfo.offset);
                                        outputBuffer.limit(mBufferInfo.offset + mBufferInfo.size);

                                        outIndex++;
                                        Log.d("StartEncoderThread","outputFrameNum is : " + outIndex);
                                    }

                                    mEncode.releaseOutputBuffer(encoderStatus, false);
                                }
                                encoderStatus = mEncode.dequeueOutputBuffer(mBufferInfo, TIMEOUT_USEC);
                            }
                            while (encoderStatus >= 0);
                        } catch (Throwable t) {
                            t.printStackTrace();
                        }
                    } else {
                        try {
                            Thread.sleep(15);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }//end if(input != null)
                }//end while (isRuning)
            }
        });
        Encoder1Thread.start();
    }

    private long computePresentationTime(long frameIndex) {
        return 132 + frameIndex * 1000000 / 30;
    }
}