package com.vivo.hapticdemo;

import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.viewpager.widget.PagerTabStrip;
import androidx.viewpager.widget.ViewPager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.DynamicEffect;
import android.os.HapticPlayer;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class MainActivity extends AppCompatActivity {

    public static final String TAG = "HapticDemo";
    private Context mContext;
    private View mRootView, mViewShort, mViewLong;
    private DrawRelativeLayout drl_shrot, drl_long_base, drl_long_fade;
    private TextView tv_relativetime, tv_instensity, tv_frequency;
    private float relativetime_s = 0, intensity_s = 0, frequency_s = 0;


    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //初始化标题栏
        LayoutInflater inflater = LayoutInflater.from(this);
        mRootView = inflater.inflate(R.layout.activity_main, null, false);
        setContentView(mRootView);
        //设置屏幕常亮
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        Log.d(TAG, "OnCreat enter!");
        mContext = getApplicationContext();
        Boolean fileExit = checkFileExit(mContext.getFilesDir().getAbsolutePath() + "/res/example.he");
        Boolean fileExit_1 = checkFileExit(mContext.getFilesDir().getAbsolutePath() + "/res/continuous_example.he");
        if (!fileExit || !fileExit_1) {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    //复制assertsm目录下文件
                    copyAssert("vibeffectHe", mContext.getFilesDir().getAbsolutePath() + "/res");
                    //changeFileAccess(mContext.getFilesDir().getAbsolutePath() + "/res");
                }
            }).start();
        }
        InterfaceInit();
        ShortHandle();
        new LongViewInit(mContext, mViewLong);
    }

    @SuppressLint("InflateParams")
    void InterfaceInit() {
        PagerTabStrip pts = findViewById(R.id.haptic_title);
        pts.setTextSize(TypedValue.COMPLEX_UNIT_SP, 25);
        pts.setTextColor(Color.WHITE);
        pts.setTabIndicatorColor(Color.WHITE);
        LayoutInflater inflater = getLayoutInflater();
        mViewShort = inflater.inflate(R.layout.haptic_short, null);
        mViewLong = inflater.inflate(R.layout.haptic_long, null);
        ArrayList<PageInfo> mViewList = new ArrayList<PageInfo>();
        PageInfo short_mode = new PageInfo();
        PageInfo long_mode = new PageInfo();
        short_mode.title = "short";
        short_mode.view = mViewShort;
        long_mode.title = "continuous";
        long_mode.view = mViewLong;
        mViewList.add(short_mode);
        mViewList.add(long_mode);
        ModeAdapter ma = new ModeAdapter(mViewList);
        ViewPager vp = findViewById(R.id.vp_head);
        vp.setAdapter(ma);
    }

    void ShortHandle() {
        drl_shrot = mViewShort.findViewById(R.id.drl_short);
        drl_shrot.setDrawType(intensity_s, frequency_s);
        tv_relativetime = mViewShort.findViewById(R.id.tv_relativetime);
        tv_instensity = mViewShort.findViewById(R.id.tv_intensity);
        tv_frequency = mViewShort.findViewById(R.id.tv_frequency);
        SeekBar sb_relativetime = mViewShort.findViewById(R.id.sb_relativetime);
        sb_relativetime.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                relativetime_s = seekBar.getProgress();
                tv_relativetime.setText("relativetime:" + " " + df.format(relativetime_s));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });

        SeekBar sb_instensity = mViewShort.findViewById(R.id.sb_intensity);
        sb_instensity.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                intensity_s = (float) seekBar.getProgress();
                tv_instensity.setText("intensity:" + " " + df.format(intensity_s));
                drl_shrot.setDrawType(intensity_s / 100f, frequency_s / 100f);
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        SeekBar sb_frequency = mViewShort.findViewById(R.id.sb_frequency);
        sb_frequency.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                frequency_s = (float) seekBar.getProgress();
                tv_frequency.setText("frequency:" + " " + df.format(frequency_s));
                drl_shrot.setDrawType(intensity_s / 100f, frequency_s / 100f);
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });

        Button short_tap = mViewShort.findViewById(R.id.btn_short);
        short_tap.setOnClickListener(new View.OnClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onClick(View v) {
                try {
                    Log.d(TAG, "[palyShort called] param: ，realtivetime =" + relativetime_s + " intensity = " + intensity_s + "，frequency = " + frequency_s);
                    if (HapticPlayer.isAvailable()) {
                        //String temp = getJson(mContext, "vibeffectHe/" + effectname);
                        // 调用Haptic震动
                        String temp = generateHeJson((int) relativetime_s, (int) intensity_s, (int) frequency_s);
                        DynamicEffect dynamicEffect = DynamicEffect.create(temp);
                        HapticPlayer mHapticPlayer = new HapticPlayer(dynamicEffect);
                        mHapticPlayer.start(1);
                    } else {
                        Log.d(TAG, "HapticPlayer is not Available");
                    }
                } catch (Exception e) {
                    Log.d(TAG, "palyShort called failed");
                    e.printStackTrace();
                }
            }
        });
    }

    private String generateHeJson(int relativetime, int intensity, int frequency) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        //使用IO流读取json文件内容
        try {
            BufferedReader bf = new BufferedReader(new FileReader(mContext.getFilesDir().getAbsolutePath() + "/res/example.he"));
            String s = null;
            while ((s = bf.readLine()) != null) {//使用readLine方法，一次读一行
                stringBuilder.append(s.trim());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        Log.d(TAG, stringBuilder.toString());
        JSONObject query = new JSONObject(stringBuilder.toString());
        if (query.getJSONArray("Pattern") != null) {
            JSONArray pattern = query.getJSONArray("Pattern");
            for (int i = 0; i < pattern.length(); i++) {
                JSONObject patternObject = pattern.getJSONObject(i);
                if (patternObject.getJSONObject("Event") != null) {
                    patternObject.getJSONObject("Event").put("RelativeTime", relativetime);
                    patternObject.getJSONObject("Event").getJSONObject("Parameters").put("Intensity", intensity);
                    patternObject.getJSONObject("Event").getJSONObject("Parameters").put("Frequency", frequency);
                }
            }
        }
        String newJsonStr = query.toString();
        Log.d(TAG, newJsonStr);
        return newJsonStr;
    }

    /**
     * 复制Assert文件夹及其中的文件到某个路径
     *
     * @param newPath oldPath 资源路径 如：vibeffectxml
     * @param newPath String 复制后的路径 如：data/user/0/com.test/res
     * @return <code>true</code> if and only if the directory and files were copied;
     * <code>false</code> otherwise
     */
    public boolean copyAssert(String oldPath, String newPath) {
        try {
            Log.d(TAG, "copyFolder enter .parm :oldPath:" + oldPath + " ,newPath:" + newPath);
            AssetManager assetManager = mContext.getAssets();
            String files[] = assetManager.list(oldPath);
            if (files == null) {
                Log.d(TAG, "files[] is null");
                return false;
            }
            for (int i = 0; i < files.length; i++) {
                Log.d(TAG, "file length is " + files.length + "files[]:" + files[i]);
            }
            String temp;
            if (files.length > 0) {//如果是子文件夹
                File newFile = new File(newPath);
                if (!newFile.exists()) {
                    if (!newFile.mkdirs()) {
                        Log.e("TAG", "copyFolder: cannot create directory.");
                        return false;
                    }
                }
                for (String filename : files) {
                    temp = oldPath + File.separator + filename;
                    copyAssert(oldPath + File.separator + filename, newPath + File.separator + filename);
                }
            } else {
                //FileInputStream fileInputStream = new FileInputStream(temp);
                InputStream fileInputStream = assetManager.open(oldPath);
                FileOutputStream fileOutputStream = new FileOutputStream(newPath);
                byte[] buffer = new byte[1024];
                int byteRead;
                while ((byteRead = fileInputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, byteRead);
                }
                fileInputStream.close();
                fileOutputStream.flush();
                fileOutputStream.close();
                Log.d(TAG, "copy " + oldPath + "to res/ success.");
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Boolean checkFileExit(String dirPath) {
        File newFile = new File(dirPath);
        if (!newFile.exists()) {
            Log.e("TAG", "directory is not exit!");
            return false;
        }
        return true;
    }
}

class LongViewInit implements DragView.OnViewMoveUpListener {
    public static final String TAG = "HapticDemo-LongViewInit";
    private Context mContext;
    private View mViewLong;
    private DrawWaveView dwl_long;
    private TextView tv_instensity_start, tv_instensity_end;
    private TextView tv_relativetime_1, tv_instensity_1, tv_frequency_1;
    private TextView tv_relativetime_2, tv_instensity_2, tv_frequency_2;
    private TextView tv_duration;
    private float intensity_start = 0, intensity_end = 0;
    private float relativetime_1 = 0, intensity_1 = 0, frequency_1 = 0;
    private float relativetime_2 = 0, intensity_2 = 0, frequency_2 = 0;
    private float duration = 5000;
    private SeekBar sb_instensity_start;
    private SeekBar sb_relativetime_1, sb_instensity_1, sb_frequency_1;
    private SeekBar sb_relativetime_2, sb_instensity_2, sb_frequency_2;
    private SeekBar sb_instensity_end;
    private SeekBar sb_duration;
    private DragView dragViewLeft, dragViewRight;

    @RequiresApi(api = Build.VERSION_CODES.O)
    public LongViewInit(Context context, View view) {
        Log.d(TAG, "LongViewInit enter");
        mContext = context;
        mViewLong = view;
        dwl_long = mViewLong.findViewById(R.id.dw1_long);
        dragViewLeft = dwl_long.findViewById(R.id.drag_view_left);
        dragViewRight = dwl_long.findViewById(R.id.drag_view_right);
        dragViewLeft.setOnViewMoveUpSbListener(this);
        dragViewRight.setOnViewMoveUpSbListener(this);
        PointStartHandle();
        Point1Handle();
        Point2Handle();
        PointEndHandle();
        ButtonInit();
    }

    public void PointStartHandle() {
        tv_instensity_start = mViewLong.findViewById(R.id.tv_intensity_long_start);
        sb_instensity_start = mViewLong.findViewById(R.id.sb_intensity_long_start);
        intensity_start = (float) sb_instensity_start.getProgress();
        sb_instensity_start.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                intensity_start = (float) seekBar.getProgress();
                tv_instensity_start.setText("intensity:" + " " + df.format(intensity_start));
                if (pressedStatus) {
                    dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                            (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });
    }

    public void Point1Handle() {
        tv_relativetime_1 = mViewLong.findViewById(R.id.tv_relatime_long_1);
        tv_instensity_1 = mViewLong.findViewById(R.id.tv_intensity_long_1);
        tv_frequency_1 = mViewLong.findViewById(R.id.tv_frequency_long_1);
        sb_relativetime_1 = mViewLong.findViewById(R.id.sb_relatime_long_1);
        relativetime_1 = sb_relativetime_1.getProgress();
        sb_relativetime_1.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                relativetime_1 = seekBar.getProgress();
                tv_relativetime_1.setText("relativetime:" + " " + df.format(relativetime_1));
                if (pressedStatus) {
                    dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                            (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });

        sb_instensity_1 = mViewLong.findViewById(R.id.sb_intensity_long_1);
        intensity_1 = (float) sb_instensity_1.getProgress();
        sb_instensity_1.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                intensity_1 = (float) seekBar.getProgress();
                tv_instensity_1.setText("intensity:" + " " + df.format(intensity_1));
                if (pressedStatus) {
                    dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                            (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });

        sb_frequency_1 = mViewLong.findViewById(R.id.sb_frequency_long_1);
        frequency_1 = (float) sb_frequency_1.getProgress();
        sb_frequency_1.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                frequency_1 = (float) seekBar.getProgress();
                tv_frequency_1.setText("frequency:" + " " + df.format(frequency_1));
                if (pressedStatus) {
                    dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                            (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });
    }

    public void Point2Handle() {
        tv_relativetime_2 = mViewLong.findViewById(R.id.tv_relatime_long_2);
        tv_instensity_2 = mViewLong.findViewById(R.id.tv_intensity_long_2);
        tv_frequency_2 = mViewLong.findViewById(R.id.tv_frequency_long_2);
        sb_relativetime_2 = mViewLong.findViewById(R.id.sb_relatime_long_2);
        relativetime_2 = sb_relativetime_2.getProgress();
        sb_relativetime_2.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                relativetime_2 = seekBar.getProgress();
                tv_relativetime_2.setText("relativetime:" + " " + df.format(relativetime_2));
                if (pressedStatus) {
                    dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                            (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });

        sb_instensity_2 = mViewLong.findViewById(R.id.sb_intensity_long_2);
        intensity_2 = (float) sb_instensity_2.getProgress();
        sb_instensity_2.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                intensity_2 = (float) seekBar.getProgress();
                tv_instensity_2.setText("intensity:" + " " + df.format(intensity_2));
                if (pressedStatus) {
                    dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                            (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });

        sb_frequency_2 = mViewLong.findViewById(R.id.sb_frequency_long_2);
        frequency_2 = (float) sb_frequency_2.getProgress();
        sb_frequency_2.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                frequency_2 = (float) seekBar.getProgress();
                tv_frequency_2.setText("frequency:" + " " + df.format(frequency_2));
                if (pressedStatus) {
                    dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                            (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });
    }

    public void PointEndHandle() {
        tv_instensity_end = mViewLong.findViewById(R.id.tv_intensity_long_end);
        sb_instensity_end = mViewLong.findViewById(R.id.sb_intensity_long_end);
        //第四个点强度为0，不可设置
        sb_instensity_end.setClickable(false);
        intensity_end = (float) sb_instensity_end.getProgress();
        sb_instensity_end.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                intensity_end = (float) seekBar.getProgress();
                tv_instensity_end.setText("intensity:" + " " + df.format(intensity_end));
                if (pressedStatus) {
                    dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                            (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    public void ButtonInit() {
        sb_duration = mViewLong.findViewById(R.id.sb_duration);
        tv_duration = mViewLong.findViewById(R.id.tv_duration);
        sb_duration.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            public boolean pressedStatus;

            @SuppressLint("SetTextI18n")
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DecimalFormat df = new DecimalFormat("#");
                duration = (float) seekBar.getProgress();
                tv_duration.setText("duration:" + " " + df.format(duration));
                //动态改变point1 时间进度条
                //float temp_1 = (float) sb_relativetime_1.getProgress() / (float) sb_relativetime_1.getMax();
                sb_relativetime_1.setMax(seekBar.getProgress());
                //tv_relativetime_1.setText("relativetime:" + " " + df.format(sb_relativetime_1.getMax() * temp_1));
                //sb_relativetime_1.setProgress((int)(sb_relativetime_1.getMax() * temp_1));
                //动态改变point2 时间进度条
                //float temp_2 = (float) sb_relativetime_2.getProgress() / (float) sb_relativetime_2.getMax();
                sb_relativetime_2.setMax(seekBar.getProgress());
                //tv_relativetime_2.setText("relativetime:" + " " + df.format(sb_relativetime_2.getMax() * temp_2));
                //sb_relativetime_2.setProgress((int)(sb_relativetime_2.getMax() * temp_2));
                dwl_long.drawWithPoints((int) intensity_start, (int) relativetime_1, (int) intensity_1,
                        (int) relativetime_2, (int) intensity_2, (int) intensity_end, (int) duration);
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                pressedStatus = true;
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                pressedStatus = false;
            }

            public boolean getPressed() {
                return pressedStatus;
            }
        });

        Button long_tap = mViewLong.findViewById(R.id.btn_long);
        long_tap.setOnClickListener(new View.OnClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onClick(View v) {
                try {
                    Log.d(TAG, "[Rich Continuous called] ，duration = " + duration);
                    Log.d(TAG, "[Rich Continuous called] param0: ，intensity = " + intensity_start + "，frequency = " + frequency_1 + " realtivetime = 0");
                    Log.d(TAG, "[Rich Continuous called] param1: ，intensity = " + intensity_1 + "，frequency = " + frequency_1 + " realtivetime =" + relativetime_1);
                    Log.d(TAG, "[Rich Continuous called] param2: ，intensity = " + intensity_2 + "，frequency = " + frequency_2 + " realtivetime =" + relativetime_2);
                    Log.d(TAG, "[Rich Continuous called] param3: ，intensity = " + intensity_end + "，frequency = " + frequency_2 + " realtivetime = " + duration);
                    if (HapticPlayer.isAvailable()) {
                        //String temp = getJson(mContext, "vibeffectHe/" + effectname);
                        // 调用Haptic震动
                        String temp = generateContinuousHeJson((int) duration, (int) intensity_start, (int) relativetime_1, (int) intensity_1, (int) frequency_1, (int) relativetime_2, (int) intensity_2, (int) frequency_2, (int) intensity_end);
                        DynamicEffect dynamicEffect = DynamicEffect.create(temp);
                        HapticPlayer mHapticPlayer = new HapticPlayer(dynamicEffect);
                        mHapticPlayer.start(1);
                    } else {
                        Log.d(TAG, "HapticPlayer is not Available");
                    }
                } catch (Exception e) {
                    Log.d(TAG, "palyShort called failed");
                    e.printStackTrace();
                }
            }
        });
    }

    private String generateContinuousHeJson(int duration, int intensity_0, int relativetime_1, int intensity_1, int frequency_1, int relativetime_2, int intensity_2, int frequency_2, int intensity_3) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        //使用IO流读取json文件内容
        try {
            BufferedReader bf = new BufferedReader(new FileReader(mContext.getFilesDir().getAbsolutePath() + "/res/continuous_example.he"));
            String s = null;
            while ((s = bf.readLine()) != null) {//使用readLine方法，一次读一行
                stringBuilder.append(s.trim());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject query = new JSONObject(stringBuilder.toString());
        DecimalFormat df = new DecimalFormat("#.##");
        //for every pattern
        if (query.getJSONArray("Pattern") != null) {
            JSONArray pattern = query.getJSONArray("Pattern");
            for (int i = 0; i < pattern.length(); i++) {
                JSONObject patternObject = pattern.getJSONObject(i);
                if (patternObject.getJSONObject("Event") != null) {
                    patternObject.getJSONObject("Event").put("Duration", duration);
                    //for every curve
                    if (patternObject.getJSONObject("Event").getJSONObject("Parameters").getJSONArray("Curve") != null) {
                        JSONArray curve = patternObject.getJSONObject("Event").getJSONObject("Parameters").getJSONArray("Curve");
                        for (int j = 0; j < curve.length(); j++) {
                            JSONObject curveObject = curve.getJSONObject(j);
                            if (j == 0) {
                                curveObject.put("Frequency", frequency_1 - 50);
                                curveObject.put("Intensity", df.format((float) intensity_0 / 100));
                                curveObject.put("Time", 0);
                            } else if (j == 1) {
                                curveObject.put("Frequency", frequency_1 - 50);
                                curveObject.put("Intensity", df.format((float) intensity_1 / 100));
                                curveObject.put("Time", relativetime_1);
                            } else if (j == 2) {
                                curveObject.put("Frequency", frequency_2 - 50);
                                curveObject.put("Intensity", df.format((float) intensity_2 / 100));
                                curveObject.put("Time", relativetime_2 - 1);
                            } else if (j == 3) {
                                curveObject.put("Frequency", frequency_2 - 50);
                                curveObject.put("Intensity", df.format((float) intensity_3 / 100));
                                curveObject.put("Time", duration);
                            }
                        }
                        patternObject.getJSONObject("Event").getJSONObject("Parameters").put("Intensity", 100);
                        patternObject.getJSONObject("Event").getJSONObject("Parameters").put("Frequency", 50);
                    }
                }
            }
        }
        String newJsonStr = query.toString();
        Log.d(TAG, newJsonStr);
        return newJsonStr;
    }

    @Override
    public void onViewMoveUp() {

    }

    @RequiresApi(api = Build.VERSION_CODES.N)
    @Override
    public void onViewMove() {
        RelativeLayout mDrawLayout = dwl_long.findViewById(R.id.draw_layout);
        Log.d(TAG, "dragViewLeft.getLeft() = " + dragViewLeft.getLeft());
        Log.d(TAG, "mViewLong.getWidth() = " + mViewLong.getWidth());
        Log.d(TAG, "mViewLong.getBottom() = " + mViewLong.getBottom());
        Log.d(TAG, "dragViewLeft.getTop() = " + dragViewLeft.getTop());
        int point1_relatime = (dragViewLeft.getLeft() + dragViewLeft.getWidth() / 2) * 5000 / mDrawLayout.getWidth();
        int point1_intensity = (mDrawLayout.getHeight() - dragViewLeft.getTop() - dragViewLeft.getHeight() / 2) * 100 / mDrawLayout.getHeight();
        int point2_relatime = (dragViewRight.getLeft() + dragViewRight.getWidth() / 2) * 5000 / mDrawLayout.getWidth();
        int point2_intensity = (mDrawLayout.getHeight() - dragViewRight.getTop() - dragViewLeft.getHeight() / 2) * 100 / mDrawLayout.getHeight();
        sb_relativetime_1.setProgress(point1_relatime, true);
        sb_instensity_1.setProgress(point1_intensity, true);
        sb_relativetime_2.setProgress(point2_relatime, true);
        sb_instensity_2.setProgress(point2_intensity, true);
    }

    @Override
    public void onViewDown() {

    }
}

class PageInfo {
    public View view;
    public String title;
}