package com.vivo.hapticdemo;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;

public class DrawWaveView extends RelativeLayout implements DragView.OnViewMoveUpListener {
    public static final String TAG = "DrawWaveView";
    public static final int INITIALVALUE = -1;
    private RelativeLayout mDrawLayout;
    private DragView dragViewLeft, dragViewRight;

    int mPointStart_x = 48, mPointStart_y = 471;
    int mPoint0_x = 48, mPoint0_y = 471;
    int mPoint1_x, mPoint1_y;
    int mPoint2_x, mPoint2_y;
    int mPoint3_x = INITIALVALUE, mPoint3_y = 471;
    int mPointEnd_x = INITIALVALUE, mPointEnd_y = 471;
    private int mPadding;
    private int mHeight;
    private int mWidth;

    private Paint mPaint = new Paint();
    private Path mPath = new Path();

    private float downX, downY; //点击时的x坐标，点击时的y坐标

    public DrawWaveView(Context context) {
        super(context);
        init(context);
    }

    public DrawWaveView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public DrawWaveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        Log.d(TAG, "init enter");
        setWillNotDraw(false);
        View view = LayoutInflater.from(context).inflate(R.layout.draw_wave_layout, this);
        mDrawLayout = view.findViewById(R.id.draw_layout);
        dragViewLeft = view.findViewById(R.id.drag_view_left);
        dragViewRight = view.findViewById(R.id.drag_view_right);
        dragViewLeft.setOnViewMoveUpListener(this);
        dragViewRight.setOnViewMoveUpListener(this);

        mPaint.setAntiAlias(true); // 设置画笔为无锯齿
        mPaint.setDither(true); // 设置画笔为防抖动
        mPaint.setColor(getResources().getColor(R.color.colorPrimary)); // 设置画笔的颜色
        mPaint.setStrokeWidth(3); // 设置画笔的线宽
        mPaint.setStyle(Paint.Style.FILL); // 设置画笔的类型。STROKE表示空心，FILL表示实心
        mPaint.setColor(getResources().getColor(R.color.colorPrimary));
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Log.d(TAG, "onMeasure enter");
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        mPadding = (int) getResources().getDimension(R.dimen.drag_layout_padding);
        mHeight = mDrawLayout.getMeasuredHeight();
        mWidth = mDrawLayout.getMeasuredWidth();
        Log.d(TAG, "onMeasure height:" + mHeight);
        Log.d(TAG, "onMeasure width:" + mWidth);
        dragViewLeft.setMaxMoveWidthAndHeight(mWidth, mHeight);
        dragViewRight.setMaxMoveWidthAndHeight(mWidth, mHeight);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Log.d(TAG, "onDraw");
        int width = mDrawLayout.getMeasuredWidth();
        int height = mDrawLayout.getMeasuredHeight();
        int left = mDrawLayout.getLeft();
        int right = mDrawLayout.getRight();
        int top = mDrawLayout.getTop();
        int bottom = mDrawLayout.getBottom();
        int dragWidth = dragViewLeft.getMeasuredWidth();
        int dragHeight = dragViewLeft.getMeasuredHeight();

        int leftDragLeft = dragViewLeft.getLeft();
        int leftDragRight = dragViewLeft.getRight();
        int leftDragTop = dragViewLeft.getTop();
        int leftDragBottom = dragViewLeft.getBottom();

        int rightDragLeft = dragViewRight.getLeft();
        int rightDragRight = dragViewRight.getRight();
        int rightDragTop = dragViewRight.getTop();
        int rightDragBottom = dragViewRight.getBottom();

        if (dragViewLeft.isPressed()) {
            if (leftDragLeft > rightDragLeft) {
                rightDragLeft = leftDragLeft;
                rightDragRight = leftDragLeft + dragWidth;
                dragViewRight.layout(rightDragLeft, rightDragTop, rightDragRight, rightDragBottom);
            }
        } else if (dragViewRight.isPressed()) {
            if (leftDragLeft > rightDragLeft) {
                leftDragLeft = rightDragLeft;
                leftDragRight = rightDragLeft + dragWidth;
                dragViewLeft.layout(leftDragLeft, leftDragTop, leftDragRight, leftDragBottom);
            }
        }

        right = right - left + mPadding;
        bottom = bottom - top + mPadding;
        left = mPadding;
        top = mPadding;
        setPointStart(left, mPointStart_y);
        setPoint0(mPoint0_x, mPoint0_y);
        setPoint1(leftDragLeft + mPadding + dragWidth / 2, leftDragTop + mPadding + dragHeight / 2);
        setPoint2(rightDragLeft + mPadding + dragWidth / 2, rightDragTop + mPadding + dragHeight / 2);
        if (mPoint3_x == INITIALVALUE || mPointEnd_x == INITIALVALUE) {
            mPoint3_x = mDrawLayout.getRight();
            mPointEnd_x = mDrawLayout.getRight();
        }
        setPoint3(mPoint3_x, mPoint3_y);
        setPointEnd(mPointEnd_x, mPointEnd_y);
        setPath();
        canvas.drawPath(mPath, mPaint);
    }

    public void setPointStart(int pointStart_x, int pointStart_y) {
        mPointStart_x = mDrawLayout.getLeft();
        mPointStart_y = pointStart_y;
    }

    public void setPoint0(int point_x, int point_y) {
        mPoint0_x = point_x;
        mPoint0_y = point_y;
    }

    public void setPoint1(int point_x, int point_y) {
        mPoint1_x = point_x;
        mPoint1_y = point_y;
    }

    public void setPoint2(int point_x, int point_y) {
        mPoint2_x = point_x;
        mPoint2_y = point_y;
    }

    public void setPoint3(int point_x, int point_y) {
        mPoint3_x = point_x;
        mPoint3_y = point_y;
    }

    public void setPointEnd(int pointEnd_x, int pointEnd_y) {
        mPointEnd_x = pointEnd_x;
        mPointEnd_y = pointEnd_y;
    }

    public void setPath() {
        mPath.reset();
        mPath.moveTo(mDrawLayout.getLeft(), mDrawLayout.getBottom());
        mPath.lineTo(mPoint0_x, mPoint0_y);
        mPath.lineTo(mPoint1_x, mPoint1_y);
        mPath.lineTo(mPoint2_x, mPoint2_y);
        mPath.lineTo(mPoint3_x, mPoint3_y);
        mPath.lineTo(mPointEnd_x, mHeight + mPadding);
        mPath.close();
    }

    public void drawWithPoints(int pointStart_y, int point1_x, int point1_y, int point2_x, int point2_y, int pointEnd_y, int duration) {
        Log.d(TAG, "drawWithPoints enter  pointStart_y = " + pointStart_y + ", pointEnd_y = " + pointEnd_y);
        Log.d(TAG, "drawWithPoints enter  point1_x = " + point1_x + ", point1_y = " + point1_y + ", point2_x = " + point2_x + ", point2_y = " + point2_y);
        int Left_l = point1_x * mWidth / 5000 - dragViewLeft.getMeasuredWidth() / 2;
        int Left_t = ((100 - point1_y) * mHeight / 100) - dragViewLeft.getMeasuredHeight() / 2;
        int Left_r = Left_l + dragViewLeft.getMeasuredWidth();
        int Left_b = Left_t + dragViewLeft.getMeasuredHeight();
        dragViewLeft.layout(Left_l, Left_t, Left_r, Left_b);
        int Right_l = point2_x * mWidth / 5000 - dragViewLeft.getMeasuredWidth() / 2;
        int Right_t = ((100 - point2_y) * mHeight / 100) - dragViewLeft.getMeasuredHeight() / 2;
        int Right_r = Right_l + dragViewLeft.getMeasuredWidth();
        int Right_b = Right_t + dragViewLeft.getMeasuredHeight();
        dragViewRight.layout(Right_l, Right_t, Right_r, Right_b);
        setPoint0(mDrawLayout.getLeft(), ((100 - pointStart_y) * mHeight / 100) + mPadding);
        setPoint3(mDrawLayout.getLeft() + duration * mDrawLayout.getWidth() / 5000, ((100 - pointEnd_y) * mHeight / 100) + mPadding);
        setPointEnd(mDrawLayout.getLeft() + duration * mDrawLayout.getWidth() / 5000, mDrawLayout.getBottom());
        invalidate();
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        float downX = ev.getX(); // 点击触屏时的x坐标 用于离开屏幕时的x坐标作计算
        float downY = ev.getY(); // 点击触屏时的y坐标 用于离开屏幕时的y坐标作计算
        if (downX > mDrawLayout.getLeft() && downX < mDrawLayout.getRight() && downY > mDrawLayout.getTop() && downY < mDrawLayout.getBottom()) {
            Log.d(TAG, "dispatchTouchEvent : in mDrawLayout,ingonre");
            getParent().requestDisallowInterceptTouchEvent(true);
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        float downX = event.getX(); // 点击触屏时的x坐标 用于离开屏幕时的x坐标作计算
        float downY = event.getY(); // 点击触屏时的y坐标 用于离开屏幕时的y坐标作计算
        if (downX > mDrawLayout.getLeft() && downX < mDrawLayout.getRight() && downY > mDrawLayout.getTop() && downY < mDrawLayout.getBottom()) {
            Log.d(TAG, "onTouchEvevt : in mDrawLayout,ingonre");
            return true;
        }
        return super.onTouchEvent(event);
    }


    @Override
    public void onViewMoveUp() {

    }

    @Override
    public void onViewMove() {
        invalidate();
    }

    @Override
    public void onViewDown() {

    }
}
