package com.vivo.hapticdemo;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ImageView;

@SuppressLint("AppCompatCustomView")
public class DragView extends ImageView {
    private int width;
    private int height;
    private int maxWidth;
    private int maxHeight;
    private Context context;
    private float downX;
    private float downY;

    public void setMaxMoveWidthAndHeight(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    private OnViewMoveUpListener onViewMoveUpListener;
    private OnViewMoveUpListener onViewMoveUpSbListener;

    public void setOnViewMoveUpListener(OnViewMoveUpListener onViewMoveUpListener) {
        this.onViewMoveUpListener = onViewMoveUpListener;
    }

    public void setOnViewMoveUpSbListener(OnViewMoveUpListener onViewMoveUpListener) {
        this.onViewMoveUpSbListener = onViewMoveUpListener;
    }

    public DragView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        width = getMeasuredWidth();
        height = getMeasuredHeight();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        return super.dispatchTouchEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.isEnabled()) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    setPressed(true);
                    downX = event.getX();
                    downY = event.getY();
                    if (null != onViewMoveUpListener) {
                        onViewMoveUpListener.onViewDown();
                    }
                    break;
                case MotionEvent.ACTION_MOVE:
                    float moveX = event.getX() - downX;
                    float moveY = event.getY() - downY;
                    int left, right, top, bottom;
                    if (Math.abs(moveX) > 0 || Math.abs(moveY) > 0) {
                        left = (int) (getLeft() + moveX);
                        right = left + width;
                        top = (int) (getTop() + moveY);
                        bottom = top + height;

                        if (left > -width / 2 && left < maxWidth - width / 2 && top > -width / 2 && top < maxHeight - width / 2) {
                            this.layout(left, top, right, bottom);
                            if (null != onViewMoveUpListener) {
                                onViewMoveUpListener.onViewMove();
                            }
                            if (null != onViewMoveUpSbListener) {
                                onViewMoveUpSbListener.onViewMove();
                            }
                        }
                    }
                    break;
                case MotionEvent.ACTION_UP:
                    if (null != onViewMoveUpListener) {
                        onViewMoveUpListener.onViewMoveUp();
                    }
                    setPressed(false);
                    break;
                case MotionEvent.ACTION_CANCEL:
                    setPressed(false);
                    break;
            }
            return true;
        }
        return false;
    }

    public interface OnViewMoveUpListener {
        void onViewMoveUp();

        void onViewMove();

        void onViewDown();
    }

}
