package com.vivo.hapticdemo;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;

public class DrawRelativeLayout extends View {
    private int mDrawType = 0; // 绘制类型
    private Paint mPaint = new Paint(); // 创建一个画笔对象
    private float mInstensity, mSharpness, mAttack, mRelease, mDuration;

    public DrawRelativeLayout(Context context) {
        this(context, null);
    }

    public DrawRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        mPaint.setAntiAlias(true); // 设置画笔为无锯齿
        mPaint.setDither(true); // 设置画笔为防抖动
        mPaint.setColor(getResources().getColor(R.color.colorPrimary)); // 设置画笔的颜色
        mPaint.setStrokeWidth(3); // 设置画笔的线宽
        mPaint.setStyle(Style.FILL); // 设置画笔的类型。STROKE表示空心，FILL表示实心
        mPaint.setColor(getResources().getColor(R.color.colorPrimary));
    }

    // onDraw方法在绘制下级视图之前调用
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float ctrl_X1;
        float ctrl_Y1;
        float ctrl_X2;
        float ctrl_Y2;
        int width = getMeasuredWidth(); // 获得布局的实际宽度
        int height = getMeasuredHeight(); // 获得布局的实际高度
        int left = getLeft();
        int right = getRight();
        int top = getTop();
        int bot = getBottom();
        right = right - left;
        bot = bot - top;
        left = 0;
        top = 0;
        if (width > 0 && height > 0) {
            Path path1 = new Path();
            if (mDrawType == 0) {
                mSharpness = 1 - mSharpness;
                ctrl_X1 = right / (4f + mSharpness * 4);
                ctrl_Y1 = (bot * (1 - mInstensity) + (bot - bot * (1 - mInstensity)) / 2) +
                        mSharpness * (bot - (bot * (1 - mInstensity) + (bot - bot * (1 - mInstensity)) / 2));
                ctrl_X2 = right / (4f + mSharpness * 4);
                ctrl_Y2 = (bot * (1 - mInstensity) + (bot - bot * (1 - mInstensity)) / 2) -
                        mSharpness * (bot - (bot * (1 - mInstensity) + (bot - bot * (1 - mInstensity)) / 2));
                path1.reset();
                path1.moveTo(left, bot);
                path1.cubicTo(ctrl_X1, ctrl_Y1, ctrl_X2, ctrl_Y2, right / 2f, bot * (1 - mInstensity));
                ctrl_X1 = (3 + mSharpness * 4) * right / (4f + mSharpness * 4);
                ctrl_Y1 = (bot * (1 - mInstensity) + (bot - bot * (1 - mInstensity)) / 2) -
                        mSharpness * (bot - (bot * (1 - mInstensity) + (bot - bot * (1 - mInstensity)) / 2));
                ctrl_X2 = (3 + mSharpness * 4) * right / (4f + mSharpness * 4);
                ctrl_Y2 = (bot * (1 - mInstensity) + (bot - bot * (1 - mInstensity)) / 2) +
                        mSharpness * (bot - (bot * (1 - mInstensity) + (bot - bot * (1 - mInstensity)) / 2));
                path1.cubicTo(ctrl_X1, ctrl_Y1, ctrl_X2, ctrl_Y2, right, bot);
                path1.lineTo(left, bot);
                path1.close();
            } else if (mDrawType == 1) {
                path1.moveTo(left, bot);
                path1.lineTo(right * mAttack, top);
                path1.lineTo(right * mAttack + (right - right * mAttack) * (1 - mRelease), top);
                path1.lineTo(right, bot);
                path1.lineTo(left, bot);
                path1.close();
            }
            canvas.drawPath(path1, mPaint);
        }
    }

    // dispatchDraw方法在绘制下级视图之前调用
    protected void dispatchDraw(Canvas canvas) {
    }

    // 设置绘制类型
    public void setDrawType(float instensity, float sharpness) {
        // 背景置为白色，目的是把画布擦干净
        mInstensity = instensity;
        mSharpness = sharpness;
        mDrawType = 0;
        // 立即重新绘图，此时会触发onDraw方法和dispatchDraw方法
        invalidate();
    }

    // 设置绘制类型
    public void setDrawFade(float attack, float release, float duration) {
        // 背景置为白色，目的是把画布擦干净
        mAttack = attack;
        mRelease = release;
        mDuration = duration;
        mDrawType = 1;
        // 立即重新绘图，此时会触发onDraw方法和dispatchDraw方法
        invalidate();
    }
}
